###  Mention the issues with traditional file-based systems that make DBMS a better choice?

There are several issues with traditional file-based systems that make a Database Management System (DBMS) a better choice:

  **Data Redundancy**: In file-based systems, data redundancy is a significant problem as the same data may be duplicated across multiple files. This leads to data inconsistency and wastage of storage space. In a DBMS, data is stored in a centralized location, and redundancy is minimized, resulting in better data consistency and less storage wastage.

**Data Integrity:** In file-based systems, data integrity is difficult to maintain because there are no constraints or rules to ensure that the data is consistent and accurate. In a DBMS, data integrity is maintained through the use of constraints and rules that ensure the correctness of the data.

 **Data Security**: File-based systems do not provide adequate data security. Data can be easily accessed by anyone who has access to the file. In a DBMS, access to data is restricted based on user roles and permissions, ensuring better data security.

  **Data Retrieval**: Retrieving data from file-based systems can be time-consuming and complicated because data is stored in multiple files. In a DBMS, data retrieval is fast and easy because data is stored in a centralized location and can be accessed through SQL queries.

 **Concurrent Access**: File-based systems do not support concurrent access, meaning that only one user can access a file at a time. In a DBMS, multiple users can access data simultaneously, ensuring that users do not have to wait for data to become available.
